/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report.urgentpath;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.report.urgentpath.AuthorizationWaiting;
import cz.insophy.inplan.report.urgentpath.CapacityWaiting;
import cz.insophy.inplan.report.urgentpath.GarPathNode;
import cz.insophy.inplan.report.urgentpath.GarWaitingComputer;
import cz.insophy.inplan.report.urgentpath.GorWaitingComputerResult;
import cz.insophy.inplan.report.urgentpath.InitialWaitingAnalyzer;
import cz.insophy.inplan.report.urgentpath.InitialWaitingAnalyzers;
import cz.insophy.inplan.report.urgentpath.MaterialWaiting;
import cz.insophy.inplan.report.urgentpath.PathNode;
import cz.insophy.inplan.report.urgentpath.Production;
import cz.insophy.inplan.report.urgentpath.ReleaseDateWaiting;
import cz.insophy.inplan.report.urgentpath.SaPathNode;
import cz.insophy.inplan.report.urgentpath.SrPathNode;
import cz.insophy.inplan.report.urgentpath.ToolWaiting;
import cz.insophy.inplan.report.urgentpath.UrgentPathInfo;
import cz.insophy.inplan.report.urgentpath.UrgentPathVisitor;
import cz.insophy.inplan.sdgraph.StoreDependencyGraph;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Collections3;
import cz.insophy.inplan.util.TimeSpan;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.problems.Problem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrgentPathInfoBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(UrgentPathInfoBuilder.class);
    private final Superplan superplan;
    private final ShopConfiguration conf;
    private final StoreDependencyGraph sdg;
    private final InitialWaitingAnalyzer initalWaitingAnalyzer;
    private final PropertyDefinition authPd;
    private final PropertyDefinition authConstraintPd;
    private Map<Material, Tuple<Double, List<TimeSpan>>> materialWaitings;
    private Map<Material, Tuple<Double, List<TimeSpan>>> toolWaitings;
    private Map<GeneralizedActionRequest, List<TimeSpan>> nothingOuterWaiting;
    private Map<GeneralizedActionRequest, List<TimeSpan>> offlinesOuterWaiting;
    private Map<GeneralizedActionRequest, List<TimeSpan>> rebuildsOuterWaiting;
    private Map<GeneralizedActionRequest, List<Tuple<TimeSpan, ActionActivity>>> productionOuterWaiting;
    private Map<GeneralizedActionRequest, List<Tuple<TimeSpan, CumulativeWorkplaceActivity>>> cumulativeProductionOuterWaiting;
    private Map<GeneralizedActionRequest, Long> logisticTimes;
    private Map<GeneralizedActionRequest, TimeSpan> releaseDateWaiting;
    private Map<GeneralizedActionRequest, TimeSpan> authorizationWaiting;
    private Map<GeneralizedActionRequest, List<Tuple<TimeSpan, ActionActivity>>> production;
    private Map<GeneralizedActionRequest, List<TimeSpan>> nothingInnerWaiting;
    private Map<GeneralizedActionRequest, List<TimeSpan>> offlinesInnerWaiting;
    private Map<GeneralizedActionRequest, List<TimeSpan>> rebuildsInnerWaiting;
    private Map<GeneralizedActionRequest, List<Tuple<TimeSpan, ActionActivity>>> productionInnerWaiting;

    UrgentPathInfoBuilder(Superplan superplan, InitialWaitingAnalyzers initalWaitingAnalyzer) {
        Preconditions.checkNotNull(superplan);
        Preconditions.checkArgument(GeneralizedRequest.isDateValid(superplan.getFixationDate()), "Superplan must have a set and valid fixation date.");
        this.superplan = superplan;
        this.conf = superplan.getShopConf();
        this.authPd = this.conf.getPropertyDefinition(GeneralizedOrderRequest.class, "authorizationDate");
        this.authConstraintPd = this.conf.getPropertyDefinition(GeneralizedOrderRequest.class, "authorizationConstraint");
        this.sdg = superplan.getSDGraph();
        this.initalWaitingAnalyzer = initalWaitingAnalyzer;
    }

    public UrgentPathInfo build(List<PathNode> up, CustomerRequest cr) {
        Preconditions.checkNotNull(up, "Urgent path cannot be null.");
        Preconditions.checkNotNull(cr, "Customer request cannot be null.");
        this.materialWaitings = Maps.newHashMap();
        this.toolWaitings = Maps.newHashMap();
        this.nothingOuterWaiting = Maps.newHashMap();
        this.offlinesOuterWaiting = Maps.newHashMap();
        this.rebuildsOuterWaiting = Maps.newHashMap();
        this.productionOuterWaiting = Maps.newHashMap();
        this.cumulativeProductionOuterWaiting = Maps.newHashMap();
        this.production = Maps.newHashMap();
        this.nothingInnerWaiting = Maps.newHashMap();
        this.offlinesInnerWaiting = Maps.newHashMap();
        this.rebuildsInnerWaiting = Maps.newHashMap();
        this.productionInnerWaiting = Maps.newHashMap();
        this.releaseDateWaiting = Maps.newHashMap();
        this.authorizationWaiting = Maps.newHashMap();
        this.logisticTimes = Maps.newHashMap();
        final ArrayList garNodes = Lists.newArrayList();
        final ArrayList<GeneralizedActionRequest> gars = Lists.newArrayList();
        if (up.isEmpty()) {
            return this.compose(gars, cr);
        }
        UrgentPathVisitor upv = new UrgentPathVisitor(){

            @Override
            public void visit(SrPathNode pathNode) {
            }

            @Override
            public void visit(SaPathNode pathNode) {
            }

            @Override
            public void visit(GarPathNode pathNode) {
                Preconditions.checkState(!pathNode.getGar().getActivities().isEmpty());
                garNodes.add(pathNode);
                gars.add(pathNode.getGar());
            }
        };
        for (PathNode pn : up) {
            pn.accept(upv);
        }
        this.initialWaiting(up.get(0), garNodes.isEmpty() ? null : (GarPathNode)garNodes.get(0), cr);
        GorWaitingComputerResult garWaitings = GarWaitingComputer.getWaitingIntervals(gars);
        for (Map.Entry<GeneralizedActionRequest, GorWaitingComputerResult.GarWaitingInfo> e : garWaitings.getWaitings()) {
            GeneralizedActionRequest gar = e.getKey();
            GorWaitingComputerResult.GarWaitingInfo gwi = e.getValue();
            this.logisticTimes.put(gar, gwi.minimumTimeBefore);
            for (GorWaitingComputerResult.WaitingPiece waiting : gwi.waitings) {
                TimeSpan ts = waiting.ts;
                boolean inGar = waiting.inGar;
                this.analyzeGarWaiting(gar, ts.getStart(), ts.getEnd(), inGar);
            }
        }
        this.production(gars);
        return this.compose(gars, cr);
    }

    private UrgentPathInfo compose(List<GeneralizedActionRequest> gars, CustomerRequest cr) {
        long fixationDate = this.superplan.getFixationDate();
        MaterialWaiting mw = this.composeMaterialWaiting(gars);
        Map<GeneralizedActionRequest, ReleaseDateWaiting> rdWait = this.composeReleaseDateWaitings();
        Map<GeneralizedActionRequest, AuthorizationWaiting> authWait = this.composeAuthorizationWaitings();
        Tuple<Map<GeneralizedActionRequest, CapacityWaiting>, Map<GeneralizedActionRequest, ToolWaiting>> capToolWaits = this.composeCapacityToolWaitings(gars);
        Map<GeneralizedActionRequest, CapacityWaiting> capWait = capToolWaits.getFirst();
        Map<GeneralizedActionRequest, ToolWaiting> toolWait = capToolWaits.getSecond();
        Map<GeneralizedActionRequest, Production> prods = this.composeProductions(gars);
        Map<GeneralizedOrderRequest, Double> mtoQtys = this.composeMtoQtys(gars, cr);
        return new UrgentPathInfo(gars, prods, mw, capWait, toolWait, rdWait, authWait, mtoQtys, fixationDate, cr, this.superplan.getSDGraph().getNode(cr).getMaterialSource(), this.superplan.getSDGraph().getNode(cr).getMatprodPreparedTime());
    }

    private MaterialWaiting composeMaterialWaiting(List<GeneralizedActionRequest> gars) {
        if (this.materialWaitings.isEmpty()) {
            return null;
        }
        ArrayList<Material> materials = Lists.newArrayList();
        ArrayList<Double> neededQties = Lists.newArrayList();
        List<TimeSpan> joinedMaterialWaitings = Lists.newArrayList();
        ArrayList<Long> lengths = Lists.newArrayList();
        for (Map.Entry<Material, Tuple<Double, List<TimeSpan>>> entry : this.materialWaitings.entrySet()) {
            Material mat = entry.getKey();
            Double qty = entry.getValue().getFirst();
            List<TimeSpan> lts = entry.getValue().getSecond();
            materials.add(mat);
            neededQties.add(qty);
            lengths.add(TimeSpan.length(lts));
            joinedMaterialWaitings.addAll(lts);
        }
        long from = (joinedMaterialWaitings = TimeSpan.intervalUnion(joinedMaterialWaitings)).isEmpty() ? -9223372036854775708L : joinedMaterialWaitings.get(0).getStart();
        long length = TimeSpan.length(joinedMaterialWaitings);
        return new MaterialWaiting(gars.isEmpty() ? null : ProductionTreeAlgorithms.getNearestGor(gars.get(0)), gars.isEmpty() ? null : gars.get(0), materials, neededQties, lengths, from, length);
    }

    private Map<GeneralizedActionRequest, ReleaseDateWaiting> composeReleaseDateWaitings() {
        HashMap<GeneralizedActionRequest, ReleaseDateWaiting> rdWait = Maps.newHashMap();
        for (Map.Entry<GeneralizedActionRequest, TimeSpan> entry : this.releaseDateWaiting.entrySet()) {
            GeneralizedActionRequest gar = entry.getKey();
            Preconditions.checkNotNull(gar);
            TimeSpan ts = entry.getValue();
            ReleaseDateWaiting rdw = new ReleaseDateWaiting(ProductionTreeAlgorithms.getNearestGor(gar), gar, ts.getStart(), ts.getLength());
            rdWait.put(gar, rdw);
        }
        return rdWait;
    }

    private Map<GeneralizedActionRequest, AuthorizationWaiting> composeAuthorizationWaitings() {
        HashMap<GeneralizedActionRequest, AuthorizationWaiting> authWait = Maps.newHashMap();
        for (Map.Entry<GeneralizedActionRequest, TimeSpan> entry : this.authorizationWaiting.entrySet()) {
            GeneralizedActionRequest gar = entry.getKey();
            Preconditions.checkNotNull(gar);
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
            TimeSpan ts = entry.getValue();
            String constraint = null;
            String constraintDesc = null;
            if (this.authConstraintPd != null && gor.getProperty(this.authConstraintPd) != null) {
                constraint = (String)gor.getProperty(this.authConstraintPd);
                CapabilityIsland island = this.superplan.getShopConf().getIsland(constraint);
                if (island != null) {
                    constraintDesc = island.getDescription();
                }
            }
            AuthorizationWaiting aw = new AuthorizationWaiting(gor, gar, constraint, constraintDesc, ts.getStart(), ts.getLength());
            authWait.put(gar, aw);
        }
        return authWait;
    }

    private Tuple<Map<GeneralizedActionRequest, CapacityWaiting>, Map<GeneralizedActionRequest, ToolWaiting>> composeCapacityToolWaitings(List<GeneralizedActionRequest> gars) {
        HashMap<GeneralizedActionRequest, CapacityWaiting> capWait = Maps.newHashMap();
        HashMap<GeneralizedActionRequest, ToolWaiting> toolWait = Maps.newHashMap();
        for (GeneralizedActionRequest gar : gars) {
            List<TimeSpan> nothings = Collections3.joinLists(this.nothingOuterWaiting.get(gar), this.nothingInnerWaiting.get(gar));
            List<TimeSpan> offlines = Collections3.joinLists(this.offlinesOuterWaiting.get(gar), this.offlinesInnerWaiting.get(gar));
            List<TimeSpan> rebuilds = Collections3.joinLists(this.rebuildsOuterWaiting.get(gar), this.rebuildsInnerWaiting.get(gar));
            List<TimeSpan> productions = UrgentPathInfoBuilder.joinLists(new Function<Tuple<TimeSpan, ActionActivity>, TimeSpan>(){

                @Override
                @Nullable
                public TimeSpan apply(@Nullable Tuple<TimeSpan, ActionActivity> input) {
                    return input.getFirst();
                }
            }, this.productionOuterWaiting.get(gar), this.productionInnerWaiting.get(gar));
            if (this.cumulativeProductionOuterWaiting.get(gar) != null) {
                productions = Collections3.joinLists(productions, Lists.newArrayList(Collections2.transform((Collection)this.cumulativeProductionOuterWaiting.get(gar), new Function<Tuple<TimeSpan, CumulativeWorkplaceActivity>, TimeSpan>(){

                    @Override
                    @Nullable
                    public TimeSpan apply(@Nullable Tuple<TimeSpan, CumulativeWorkplaceActivity> input) {
                        return input.getFirst();
                    }
                })));
            }
            List<TimeSpan> allNothings = TimeSpan.intervalUnion(nothings);
            List<TimeSpan> toolWaits = Lists.newArrayList();
            ArrayList<Material> tools = Lists.newArrayList();
            ArrayList<Double> qties = Lists.newArrayList();
            ArrayList<Long> lengths = Lists.newArrayList();
            for (Material tool : gar.getAction().getBom().materials()) {
                Tuple<Double, List<TimeSpan>> qTs = this.toolWaitings.get(tool);
                if (qTs == null) continue;
                Double qty = qTs.getFirst();
                List<TimeSpan> timeSpans = qTs.getSecond();
                List<TimeSpan> toolW = TimeSpan.intersection(allNothings, TimeSpan.intervalUnion(timeSpans));
                if (toolW.isEmpty()) continue;
                toolWaits.addAll(toolW);
                tools.add(tool);
                qties.add(qty);
                lengths.add(TimeSpan.length(toolW));
            }
            if (!toolWaits.isEmpty()) {
                toolWaits = TimeSpan.intervalUnion(toolWaits);
                ToolWaiting tw = new ToolWaiting(ProductionTreeAlgorithms.getNearestGor(gar), gar, tools, qties, lengths, toolWaits.get(0).getStart(), TimeSpan.length(toolWaits));
                toolWait.put(gar, tw);
                nothings = TimeSpan.difference(nothings, toolWaits);
            }
            List<TimeSpan> all = Lists.newArrayList();
            all.addAll(nothings);
            all.addAll(offlines);
            all.addAll(rebuilds);
            all.addAll(productions);
            if ((all = TimeSpan.difference(TimeSpan.intervalUnion(all), toolWaits)).isEmpty()) continue;
            CapacityWaiting cw = new CapacityWaiting(ProductionTreeAlgorithms.getNearestGor(gar), gar, gar.getAction().getCapabilityReq(), this.conf.getWorkplaces(gar.getAction().getCapabilityReq()).get(0).getDescription(), gar.getAction().normtime(gar.getRequestedQty() - gar.getOutOfPlanQty()), all.isEmpty() ? -9223372036854775708L : all.get(0).getStart(), TimeSpan.length(all), TimeSpan.length(productions) + TimeSpan.length(rebuilds), TimeSpan.length(offlines), TimeSpan.length(nothings));
            capWait.put(gar, cw);
        }
        return Tuple.create(capWait, toolWait);
    }

    private Map<GeneralizedActionRequest, Production> composeProductions(List<GeneralizedActionRequest> gars) {
        HashMap<GeneralizedActionRequest, Production> prods = Maps.newHashMap();
        for (GeneralizedActionRequest gar : gars) {
            List<Tuple<TimeSpan, ActionActivity>> pr = this.production.get(gar);
            if (pr == null) continue;
            List<TimeSpan> prod = Lists.newArrayList(Collections2.transform(pr, new Function<Tuple<TimeSpan, ActionActivity>, TimeSpan>(){

                @Override
                @Nullable
                public TimeSpan apply(@Nullable Tuple<TimeSpan, ActionActivity> input) {
                    return input.getFirst();
                }
            }));
            prod = TimeSpan.intervalUnion(prod);
            ArrayList<Workplace> workplaces = Lists.newArrayList(Collections2.transform(pr, new Function<Tuple<TimeSpan, ActionActivity>, Workplace>(){

                @Override
                @Nullable
                public Workplace apply(@Nullable Tuple<TimeSpan, ActionActivity> input) {
                    return input.getSecond().getWorkplace();
                }
            }));
            Long lt = this.logisticTimes.get(gar);
            Production p = new Production(ProductionTreeAlgorithms.getNearestGor(gar), gar, gar.getAction().getCapabilityReq(), this.conf.getWorkplaces(gar.getAction().getCapabilityReq()).get(0).getDescription(), workplaces, gar.getAction().normtime(gar.getRequestedQty() - gar.getOutOfPlanQty()), lt == null ? 0L : lt, UrgentPathInfoBuilder.getEarliestStart(prod), UrgentPathInfoBuilder.getLatestEnd(prod), TimeSpan.length(prod));
            prods.put(gar, p);
        }
        return prods;
    }

    private Map<GeneralizedOrderRequest, Double> composeMtoQtys(List<GeneralizedActionRequest> gars, CustomerRequest cr) {
        HashMap<GeneralizedOrderRequest, Double> res = Maps.newHashMap();
        HashSet<GeneralizedOrderRequest> clearedGors = Sets.newHashSet();
        for (GeneralizedActionRequest gar : gars) {
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
            if (clearedGors.contains(gor)) continue;
            double qty = this.sdg.getNode(gor).getProbabilisticMttQty(this.sdg.getNode(cr));
            res.put(gor, qty);
            clearedGors.add(gor);
        }
        return res;
    }

    private void production(List<GeneralizedActionRequest> gars) {
        for (GeneralizedActionRequest gar : gars) {
            long end;
            ActionActivity aa;
            long start;
            Iterator<ActionActivity> iterator = gar.getActivities().iterator();
            while (iterator.hasNext() && (start = (aa = iterator.next()).getStart()) < (end = aa.getEnd())) {
                List<Tuple<TimeSpan, ActionActivity>> l = this.production.get(gar);
                if (l == null) {
                    l = Lists.newArrayList();
                    l.add(Tuple.create(TimeSpan.fromStartEnd(start, end), aa));
                    this.production.put(gar, l);
                    continue;
                }
                l.add(Tuple.create(TimeSpan.fromStartEnd(start, end), aa));
            }
        }
    }

    private void initialWaiting(@Nonnull PathNode firstNode, @Nullable GarPathNode firstGar, @Nonnull CustomerRequest cr) {
        this.initalWaitingAnalyzer.initialWaiting(firstNode, firstGar, cr, this);
    }

    protected void analyzeCapacityWaiting(GeneralizedActionRequest gar, long from, long to) {
        if (from >= to) {
            return;
        }
        ArrayList<TimeSpan> nothing = Lists.newArrayList();
        ArrayList<TimeSpan> offlines = Lists.newArrayList();
        ArrayList<TimeSpan> rebuilds = Lists.newArrayList();
        ArrayList<Tuple<TimeSpan, ActionActivity>> production = Lists.newArrayList();
        ArrayList<Tuple<TimeSpan, CumulativeWorkplaceActivity>> cumulativeProduction = Lists.newArrayList();
        List<Workplace> workplaces = this.conf.getWorkplaces(gar.getAction().getCapabilityReq());
        block0: for (Workplace workplace : workplaces) {
            WorkplaceSchedule workplaceSchedule = this.superplan.getPlan().getWorkplaceSchedule(workplace);
            Iterator<WorkplaceActivity> workplaceActivityIterator = workplaceSchedule.forwardIteratorWithBubblesCut(from);
            while (workplaceActivityIterator.hasNext()) {
                WorkplaceActivity wa = workplaceActivityIterator.next();
                if (wa instanceof Bubble) {
                    nothing.add(TimeSpan.fromStartEnd(Math.max(wa.getStart(), from), Math.min(wa.getEnd(), to)));
                } else if (wa instanceof OfflineActivity) {
                    offlines.add(TimeSpan.fromStartEnd(Math.max(wa.getStart(), from), Math.min(wa.getEnd(), to)));
                } else if (wa instanceof RebuildActivity) {
                    rebuilds.add(TimeSpan.fromStartEnd(Math.max(wa.getStart(), from), Math.min(wa.getEnd(), to)));
                } else if (wa instanceof ActionActivity) {
                    production.add(Tuple.create(TimeSpan.fromStartEnd(Math.max(wa.getStart(), from), Math.min(wa.getEnd(), to)), (ActionActivity)wa));
                } else if (wa instanceof CumulativeWorkplaceActivity) {
                    cumulativeProduction.add(Tuple.create(TimeSpan.fromStartEnd(Math.max(wa.getStart(), from), Math.min(wa.getEnd(), to)), (CumulativeWorkplaceActivity)wa));
                }
                if (wa.getEnd() < to) continue;
                continue block0;
            }
        }
        if (this.nothingOuterWaiting.get(gar) != null) {
            this.nothingOuterWaiting.get(gar).addAll(nothing);
        } else {
            this.nothingOuterWaiting.put(gar, nothing);
        }
        if (this.offlinesOuterWaiting.get(gar) != null) {
            this.offlinesOuterWaiting.get(gar).addAll(offlines);
        } else {
            this.offlinesOuterWaiting.put(gar, offlines);
        }
        if (this.rebuildsOuterWaiting.get(gar) != null) {
            this.rebuildsOuterWaiting.get(gar).addAll(rebuilds);
        } else {
            this.rebuildsOuterWaiting.put(gar, rebuilds);
        }
        if (this.productionOuterWaiting.get(gar) != null) {
            this.productionOuterWaiting.get(gar).addAll(production);
        } else {
            this.productionOuterWaiting.put(gar, production);
        }
        if (this.cumulativeProductionOuterWaiting.get(gar) != null) {
            this.cumulativeProductionOuterWaiting.get(gar).addAll(cumulativeProduction);
        } else {
            this.cumulativeProductionOuterWaiting.put(gar, cumulativeProduction);
        }
    }

    protected void analyzeToolWaiting(GeneralizedActionRequest gar, long from, long to) {
        if (from >= to) {
            return;
        }
        block0: for (Material tool : gar.getAction().getBom().materials()) {
            if (tool.isConsumed()) continue;
            double neededQ = gar.getAction().getBom().getQty(tool);
            long lastTime = from;
            StoreSchedule storeSchedule = this.superplan.getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
            boolean isMissing = storeSchedule.getQ(tool, from, true) - neededQ < -1.0E-7;
            Iterator<Tuple<Long, Double>> storeIterator = storeSchedule.quantityIterator(tool, true, from);
            while (storeIterator.hasNext()) {
                Tuple<Long, Double> q = storeIterator.next();
                if (q.getFirst() <= from) continue;
                long time = Math.min(to, q.getFirst());
                if (isMissing) {
                    List<TimeSpan> lts;
                    Tuple<Double, List<TimeSpan>> waitingTuple = this.toolWaitings.get(tool);
                    List<TimeSpan> list = lts = waitingTuple == null ? null : waitingTuple.getSecond();
                    if (waitingTuple == null || lts == null || lts.isEmpty()) {
                        this.toolWaitings.put(tool, Tuple.create(neededQ, Lists.newArrayList(TimeSpan.fromStartEnd(lastTime, time))));
                    } else {
                        lts.add(TimeSpan.fromStartEnd(lastTime, time));
                    }
                }
                boolean bl = isMissing = q.getSecond() - neededQ < -1.0E-7;
                if (time >= to) continue block0;
                lastTime = time;
            }
        }
    }

    protected void analyzeGarWaiting(GeneralizedActionRequest gar, long from, long to, boolean inGar) {
        TimeSpan aWaiting;
        long effectiveFrom = from;
        TimeSpan rdWaiting = this.getReleaseDateWaiting(gar, from, to);
        if (rdWaiting != null) {
            this.releaseDateWaiting.put(gar, rdWaiting);
            Preconditions.checkState(rdWaiting.getEnd() <= to);
            effectiveFrom = Math.max(effectiveFrom, rdWaiting.getEnd());
        }
        if ((aWaiting = this.getAuthorizationWaiting(gar, from, to)) != null) {
            Preconditions.checkState(aWaiting.getEnd() <= to);
            this.authorizationWaiting.put(gar, aWaiting);
            effectiveFrom = Math.max(effectiveFrom, aWaiting.getEnd());
        }
        this.analyzeCapacityWaiting(gar, effectiveFrom, to);
        if (!inGar) {
            this.analyzeToolWaiting(gar, effectiveFrom, to);
        }
    }

    private TimeSpan getReleaseDateWaiting(GeneralizedActionRequest gar, long from, long to) {
        GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
        if (gar != UrgentPathInfoBuilder.getFirstInPlanGar(gor)) {
            return null;
        }
        if (from < gor.getReleaseDate() && gor.getReleaseDate() <= to) {
            return TimeSpan.fromStartEnd(from, gor.getReleaseDate());
        }
        return null;
    }

    private TimeSpan getAuthorizationWaiting(GeneralizedActionRequest gar, long from, long to) {
        GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
        if (gar != UrgentPathInfoBuilder.getFirstInPlanGar(gor)) {
            return null;
        }
        if (gor.getReleaseDate() < this.getAuthRdTime(gor)) {
            if (from < gor.getReleaseDate()) {
                return TimeSpan.fromStartEnd(gor.getReleaseDate(), Math.min(this.getAuthRdTime(gor), to));
            }
            if (from < this.getAuthRdTime(gor)) {
                return TimeSpan.fromStartEnd(from, Math.min(this.getAuthRdTime(gor), to));
            }
        }
        return null;
    }

    protected long getAuthRdTime(GeneralizedOrderRequest gor) {
        if (this.authPd == null) {
            return gor.getReleaseDate();
        }
        Long auth = (Long)gor.getProperty(this.authPd);
        return auth == null ? gor.getReleaseDate() : Math.max(auth, gor.getReleaseDate());
    }

    private static long getEarliestStart(List<TimeSpan> lts) {
        Long ret = null;
        for (TimeSpan ts : lts) {
            if (ret != null && (ret <= ts.getStart() || !GeneralizedRequest.isDateValid(ts.getStart()))) continue;
            ret = ts.getStart();
        }
        if (ret == null || !GeneralizedRequest.isDateValid(ret)) {
            return -9223372036854775708L;
        }
        return ret;
    }

    private static long getLatestEnd(List<TimeSpan> lts) {
        Long ret = null;
        for (TimeSpan ts : lts) {
            if (ret != null && (ret >= ts.getEnd() || !GeneralizedRequest.isDateValid(ts.getEnd()))) continue;
            ret = ts.getEnd();
        }
        if (ret == null || !GeneralizedRequest.isDateValid(ret)) {
            return -9223372036854775708L;
        }
        return ret;
    }

    private static GeneralizedActionRequest getFirstInPlanGar(GeneralizedOrderRequest gor) {
        for (int i = 0; i < gor.getGars().size(); ++i) {
            if (!UrgentPathInfoBuilder.isGarInPlan(gor.getGars().get(i))) continue;
            return gor.getGars().get(i);
        }
        return null;
    }

    protected static boolean isGarInPlan(GeneralizedActionRequest gar) {
        if (gar.getAmount() > 1.0E-7) {
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(gar);
            Problem.createProblem("04150", "UrgentPath", gor.getId(), false, gar.getAction().getName(), gor.getId()).logProblem(LOG);
        }
        return Math.abs(gar.getRequestedQty() - (gar.getOutOfPlanQty() + gar.getAmount())) >= 1.0E-7 || Math.abs(gar.getRequestedQty() - gar.getOutOfPlanQty()) >= 1.0E-7;
    }

    @SafeVarargs
    private static <F, T> List<T> joinLists(Function<F, T> transf, List<F> ... lists) {
        ArrayList<T> res = Lists.newArrayList();
        for (List<F> list : lists) {
            if (list == null) continue;
            res.addAll(Collections2.transform(list, transf));
        }
        return res;
    }

    protected Superplan getSuperplan() {
        return this.superplan;
    }

    protected Map<GeneralizedActionRequest, Long> getLogisticTimes() {
        return this.logisticTimes;
    }

    protected Map<Material, Tuple<Double, List<TimeSpan>>> getMaterialWaitings() {
        return this.materialWaitings;
    }
}

